import {createStore, applyMiddleware, compose, combineReducers} from 'redux';
import thunkMiddleware from 'redux-thunk';
import publicId from '@blocks/reducers/publicId';
import common from '@blocks/common/reducers';
import header from '@blocks/morda/components/header/reducers';
import form from '@blocks/reducers/form';
import isLoading from '@blocks/reducers/spin';

const stub = (state = {}) => state;
const rootReducer = combineReducers({
    common,
    header,
    person: stub,
    access: stub,
    settings: stub,
    footer: stub,
    dashboard: stub,
    metrics: stub,
    monitoring: stub,
    form,
    publicId,
    isLoading,
    tracks: stub
});

const devTools =
    typeof window === 'object' &&
    typeof window.devToolsExtension !== 'undefined' &&
    process.env.NODE_ENV !== 'production'
        ? window.devToolsExtension()
        : (f) => f;

export default function(initialState) {
    return createStore(rootReducer, initialState, compose(applyMiddleware(thunkMiddleware), devTools));
}
