import {renderServer} from '@components/Layout/server';
import {ActivityAlert} from '@blocks/pushes/ActivityAlert';
import configureStore from './configureStore';
import {darkTheme} from 'pcomponents/Theme/darkTheme';

export const renderPage = (res) => {
    const {store = {}} = res.locals;
    const {settings = {}} = store;
    const {theme} = settings;
    const isDarkTheme = theme === 'dark';
    const baseBodyClasses = 'Theme_color_yandex-default Theme_root_passport Theme_auth_domik';
    const themeInfo = {
        name: isDarkTheme ? 'dark' : 'default',
        cssBodyClass: isDarkTheme ? `${baseBodyClasses} ${darkTheme}` : `Theme_root_default ${baseBodyClasses}`
    };

    renderServer(res, {
        title: i18n('_AUTH_.title.authorization'),
        App: ActivityAlert,
        configureStore,
        extraProps: {themeInfo}
    });
};
