import {renderServer} from '@components/Layout/server';
import App from './app';
import configureStore from './configureStore';

export const renderPage = (res) => {
    const {store = {}} = res.locals;
    const {common = {}} = store;
    const {loadCustomsStyles} = common;
    const baseBodyClasses = 'Theme_color_yandex-default Theme_root_passport Theme_auth_domik';
    const themeInfo = {
        name: 'default',
        cssBodyClass: `Theme_root_default ${baseBodyClasses}`
    };

    renderServer(res, {
        title: i18n('_AUTH_.title.authorization'),
        App,
        configureStore,
        extraProps: {loadCustomsStyles, themeInfo}
    });
};
