import {createStore, combineReducers, applyMiddleware, compose} from 'redux';
import thunkMiddleware from 'redux-thunk';
import reducers from '@blocks/passport.reducers';
import {connectRouter, routerMiddleware} from 'connected-react-router';
import {createReduxMiddleware as createNativeMobileApiReduxMiddleware} from '@blocks/authv2/nativeMobileApi';

const getRootReducer = (history) =>
    combineReducers(
        Object.assign({}, reducers, {
            router: connectRouter(history)
        })
    );

const devTools =
    typeof window === 'object' &&
    typeof window.devToolsExtension !== 'undefined' &&
    process.env.NODE_ENV !== 'production'
        ? window.devToolsExtension()
        : (f) => f;

export default function(initialState, history) {
    const middlewares = [thunkMiddleware, routerMiddleware(history)];

    if (typeof window === 'object' && initialState.am && initialState.am.isAm) {
        middlewares.push(createNativeMobileApiReduxMiddleware(initialState));
    }

    return createStore(getRootReducer(history), initialState, compose(applyMiddleware(...middlewares), devTools));
}
