import {renderClient} from '@components/Layout/client';
import configureStore from './configureStore';
import {FamilyPush} from '@blocks/pushes/FamilyPush';
import createBrowserHistory from 'history/createBrowserHistory';

document.addEventListener('DOMContentLoaded', () => {
    const history = createBrowserHistory();

    history.listen(() => (window || {}).scrollTo && window.scrollTo(0, 0));

    renderClient({
        App: FamilyPush,
        configureStore,
        withRouter: true,
        history
    });
});
