import {renderServer} from '@components/Layout/server';
import {QrSecureAuth} from '@blocks/pushes/QrSecureAuth';
import configureStore from './configureStore';
import {darkTheme} from 'pcomponents/Theme/darkTheme';

export const renderPage = (res) => {
    const {store = {}} = res.locals;
    const {settings = {}, common = {}, am = {}} = store;
    const {isAm} = am;
    const {theme} = settings;
    const isDarkTheme = theme === 'dark';
    const baseBodyClasses = 'Theme_color_yandex-default Theme_root_passport Theme_auth_domik';
    const themeInfo = {
        name: isDarkTheme ? 'dark' : 'default',
        cssBodyClass: isDarkTheme ? `${baseBodyClasses} ${darkTheme}` : `Theme_root_default ${baseBodyClasses}`
    };
    const {experiments = {}} = common;
    const {flags = []} = experiments;
    const isSliderConfirmationDesignExp = flags.includes('slider-confirmation-design');
    const isWebPushModal = isSliderConfirmationDesignExp;
    const loadCustomsStyles = !isAm && isSliderConfirmationDesignExp;

    renderServer(res, {
        title: i18n('_AUTH_.title.authorization'),
        App: QrSecureAuth,
        configureStore,
        extraProps: {themeInfo, isWebPushModal, loadCustomsStyles}
    });
};
