import {createStore, applyMiddleware, compose} from 'redux';
import thunkMiddleware from 'redux-thunk';
import mainRegReducers from '@blocks/registration/reducers/main';

const devTools =
    typeof window === 'object' &&
    typeof window.devToolsExtension !== 'undefined' &&
    process.env.NODE_ENV !== 'production'
        ? window.devToolsExtension()
        : (f) => f;

export default function(initialState) {
    return createStore(mainRegReducers, initialState, compose(applyMiddleware(thunkMiddleware), devTools));
}
