import React, {Component} from 'react';
import PropTypes from 'prop-types';
import {NoJS} from '@components/NoJS';
import {CheckCSSLoad} from '@components/CheckCSSLoad';
import Registration from '@blocks/registration/desktop/registration.jsx';

export class App extends Component {
    static propTypes = {
        sendFingerprint: PropTypes.func.isRequired,
        canSendFingerprint: PropTypes.bool
    };

    componentDidMount() {
        if (this.props.canSendFingerprint) {
            this.props.sendFingerprint();
        }
    }

    render() {
        return (
            <div className='layout-inner'>
                <NoJS />
                <div className='grid'>
                    <Registration />
                    <CheckCSSLoad />
                </div>
            </div>
        );
    }
}
