import {renderClient} from '@components/Layout/client';
import broker from '@blocks/authv2/broker';
import configureStore from './configureStore';
import {App} from './App';

document.addEventListener('DOMContentLoaded', () => {
    const reduxStore = window.__REDUX_STORE__;

    ['firstname', 'lastname', 'login', 'password', 'password_confirm', 'phone', 'hint_answer', 'captcha'].forEach(
        (fieldName) => {
            const field = document.getElementById(fieldName);

            if (field && field.value) {
                reduxStore.form.values[fieldName] = field.value;
                reduxStore.form.states[fieldName] = 'need_validation';
            }
        }
    );

    renderClient({
        App,
        configureStore,
        withCheckHuman: true,
        broker
    });
});
