import React from 'react';
import {connect} from 'react-redux';
import PropTypes from 'prop-types';
import {RequestDataDomik} from '@components/RequestDataDomik';
import Header from '@components/Header/Header.jsx';
import Footer from '@components/Footer/Footer.jsx';
import {CustomsBackground} from '@components/CustomsBackground';
import {Security} from '@blocks/Security';

const App = ({isForced}) => (
    <div className='layout-inner'>
        {!isForced && <Header />}
        <CustomsBackground />
        <Security />
        <Footer />
        <RequestDataDomik />
    </div>
);

App.propTypes = {
    isForced: PropTypes.bool
};

const ConnectedApp = connect((state = {}) => {
    const {common = {}} = state;
    const {forced} = common;

    return {
        isForced: forced
    };
})(App);

export {ConnectedApp as App};
