import React, {Fragment, Component} from 'react';
import PropTypes from 'prop-types';
import {connect} from 'react-redux';
import Header from '@components/Header/Header.jsx';
import Footer from '@components/Footer/Footer.jsx';
import {Domik} from '@blocks/morda/components/domik/domik.jsx';
import DataInfo from '@blocks/takeout/components/DataInfo/DataInfo.jsx';
import SectionTitle from '@blocks/takeout/components/SectionTitle/SectionTitle.jsx';
import ArchiveDescription from '@blocks/takeout/components/ArchiveDescription/ArchiveDescription.jsx';

class App extends Component {
    render() {
        const {
            settings: {ua, tld},
            common,
            header
        } = this.props;
        const isMobile = ua.isMobile && !ua.isTablet;
        const {isSocialchik} = common;
        const {
            defaultAccount: {login}
        } = header;
        const socialText = i18n('TakeOut.getdata_social')
            .replace('%link_1', '<a href="/profile/upgrade">')
            .replace('%link_2', '</a>');
        const supportLink = `https://yandex.${tld}/support/passport/getdata.html`;

        return (
            <div className='layout-inner'>
                <Header />
                <div className='grid'>
                    <div className='getdata-container'>
                        <SectionTitle isMobile={!isMobile} />
                        {isSocialchik ? (
                            <p dangerouslySetInnerHTML={{__html: socialText}} />
                        ) : (
                            <Fragment>
                                <DataInfo />
                                <ArchiveDescription tld={tld} />
                                <div
                                    className='getdata-disclaimer'
                                    dangerouslySetInnerHTML={{
                                        __html: i18n('TakeOut.getdata_disclaimer')
                                            .replace('%name', login)
                                            .replace('%attr', `href=${supportLink}`)
                                    }}
                                />
                            </Fragment>
                        )}
                    </div>
                </div>
                <Domik />
                <Footer />
            </div>
        );
    }
}

App.propTypes = {
    settings: PropTypes.shape({
        ua: PropTypes.shape({
            isMobile: PropTypes.bool,
            isTablet: PropTypes.bool
        }).isRequired,
        tld: PropTypes.string
    }).isRequred,
    common: PropTypes.shape({
        isSocialchik: PropTypes.bool
    }).isRequired,
    header: PropTypes.shape({
        defaultAccount: PropTypes.shape({
            login: PropTypes.string
        }).isRequred
    }).isRequred
};

export default connect((state) => {
    const {settings, common, header, person} = state;

    return {
        settings,
        common,
        header,
        person
    };
})(App);
