import React from 'react';
import Footer from '@components/Footer/Footer.jsx';
import {UserValidate} from '@blocks/UserValidate';
import {CustomsBackground} from '@components/CustomsBackground';
import PropTypes from 'prop-types';
import {connect} from 'react-redux';

class App extends React.Component {
    render() {
        const {hideFooter} = this.props;

        return (
            <div className='layout-inner'>
                <CustomsBackground />
                <UserValidate />
                {!hideFooter && <Footer />}
            </div>
        );
    }
}

App.propTypes = {
    hideFooter: PropTypes.bool
};

const mapStateToProps = ({footer: {hideFooter = false} = {}} = {}) => ({
    hideFooter
});

const ConnectedApp = connect(mapStateToProps)(App);

export {ConnectedApp as App};
