import React from 'react';
import {useSelector} from 'react-redux';
import {Verification} from '@blocks/Verification';
import {RequestDataDomik} from '@components/RequestDataDomik';
import Header from '@components/Header/Header.jsx';
import Footer from '@components/Footer/Footer.jsx';
import {PageWrapper} from '@components/PageWrapper';

export const App = () => {
    const isNewLayout = useSelector((state) => state.settings.isNewLayout);

    return (
        <PageWrapper isNavigationHidden={true}>
            <div className='layout-inner'>
                {!isNewLayout && <Header hideNavigation={true} />}
                <Verification />
                <RequestDataDomik />
                <Footer />
            </div>
        </PageWrapper>
    );
};
