import {createStore, applyMiddleware, compose} from 'redux';
import thunkMiddleware from 'redux-thunk';
import {verificationReducer} from '@blocks/Verification/reducers';

const devTools =
    typeof window === 'object' &&
    typeof window.devToolsExtension !== 'undefined' &&
    process.env.NODE_ENV !== 'production'
        ? window.devToolsExtension()
        : (f) => f;

export default function(initialState) {
    return createStore(verificationReducer, initialState, compose(applyMiddleware(thunkMiddleware), devTools));
}
