/* borschik:include:{{RELATIVEROOT}}/blocks/blocks.js */
/* borschik:include:{{RELATIVEROOT}}/blocks/field-hint/field-hint.js */
/* borschik:include:{{RELATIVEROOT}}/blocks/metrics/restore-metrics.js */

(function() {
    var originPhoneAcknowledgementMethod = passport.block('phone-confirm-acknowledgement').show;

    if (!$('.restore-suggest').length) {
        passport.block('phone-confirm-acknowledgement').show = function() {
            passport.block('restore-metrics').onPhoneSuccessConfirm(this.getModel().isValidForCall);
            location.reload();
        };
    }

    if ($('.restore-success').length) {
        passport
            .block('restore-metrics')
            .clearStep()
            .send('Пароль успешно восстановлен');
    }

    passport.block('pin').onSuccess = function() {
        location.reload();
    };

    passport.block('restore-methods', {
        events: {
            'change .js-method': 'submit'
        },

        val: function() {
            return this.$('input:checked').val();
        },

        submit: function() {
            this.emit(this.val() === 'phone' ? 'onEntryPhone' : 'onEntryEmail');
            this.$el.submit();
        },

        init: function() {
            this.emit('showRestoreMethods');
        }
    });

    passport.block('hint-entry', 'control', {
        needsServerValidation: false,
        isRequired: false,

        events: {
            'click .js-submit': 'checkEntry',
            'blur ._nb-input-controller': 'onBlur'
        },

        checkEntry: function(event) {
            event.preventDefault();

            if (this.val().trim() === '') {
                this.error('missingvalue');
                return;
            }

            this.submit();
        },

        onBlur: function() {
            if (!this.isEmpty()) {
                this.emit('onEntry');
            }
        },

        submit: function() {
            this.emit('onSubmit');
            this.$el.closest('form').submit();
        },

        init: function() {
            this.captcha = passport.block('captcha');

            this.inited.done(
                function() {
                    this.isRequired = this.$ctrl.data('required');
                }.bind(this)
            );

            this.emit('showEntry');
        }
    });

    ['email-entry', 'key-entry'].forEach(function(block) {
        passport.block(block, 'hint-entry', {
            events: {
                'click .js-submit': 'checkEntry'
            },

            checkEntry: function(event) {
                event.preventDefault();

                if (this.val().trim() === '') {
                    this.error('missingvalue');
                    return;
                }

                this.emit('onEntry');
                this.submit();
            }
        });
    });

    passport.block('methods-to-bind', {
        events: {
            change: 'toggleMethods'
        },

        val: function() {
            return this.$('input:checked').val() || 'phone';
        },

        setRequiredParam: function() {
            var method = this.val();

            this.phone.isRequired = false;
            this.phoneEntry.isRequired = false;
            this.phoneCode.isRequired = false;
            this.question.isRequired = false;
            this.answer.isRequired = false;

            if (method === 'phone') {
                this.phone.isRequired = true;
                this.phoneEntry.isRequired = true;
                this.phoneCode.isRequired = true;
            }

            if (method === 'hint') {
                this.phoneEntry.inited.done(function(cntrl) {
                    cntrl.val('');
                });
                this.phoneCode.inited.done(function(cntrl) {
                    cntrl.val('');
                });
                this.question.isRequired = true;
                this.answer.isRequired = true;
            }
        },

        toggleMethods: function() {
            var method = this.val();

            this.$('.js-method').addClass('g-hidden');
            this.$('.js-method-' + method).removeClass('g-hidden');

            this.setRequiredParam();
        },

        init: function() {
            passport.block('phone-confirm-acknowledgement').show = originPhoneAcknowledgementMethod;

            this.phone = passport.block('phone-confirm');
            this.phoneEntry = passport.block('phone-confirm-entry');
            this.phoneCode = passport.block('phone-confirm-code');
            this.question = passport.block('question');
            this.answer = passport.block('answer');

            this.setRequiredParam();
        }
    });

    passport.block('restore-phone-suggest', {
        events: {
            'phoneConfirmed.phone-confirm': 'replaceButton',
            'click .js-restore-retpath .nb-button': 'onRestoreRetpathClick',
            'click .restore-suggest-btn': 'onRestoreSuggestBtnClick'
        },

        onRestoreRetpathClick: function() {
            passport.block('restore-metrics').send('Вернуться на сервис');
        },

        onRestoreSuggestBtnClick: function() {
            passport.block('restore-metrics').send('Пропустить и вернуться на сервис');
        },

        replaceButton: function() {
            this.$('.js-bind-phone').addClass('g-hidden');
            $('.js-restore-retpath').removeClass('g-hidden');
        },

        init: function() {
            passport.block('restore-metrics').setStep('Привязка телефона');
        }
    });

    $('.js-select-revoke').click(function() {
        $('.js-revoke-warning').toggleClass('g-hidden');

        var msg = !$('.js-select-revoke input').is(':checked')
            ? 'Поставили галочку "отозвать токены"'
            : 'Сняли галочку "отозвать токены"';

        passport.block('restore-metrics').send(msg);
    });

    passport.block('restore-metrics').init('Второй шаг');
})();

$(function() {
    var flags = $('body').data('flags');

    function goal(id) {
        var target = id;

        if (flags) {
            target = flags.replace('=', '_') + '_' + id;
        }

        passport.Metrika.reachGoal(target);
    }

    passport.init();
    nb.init();

    if (!passport.isTouch && !passport.isTablet) {
        $('input:visible')
            .first()
            .focus();
    }

    if ($('.restore-success').length) {
        goal('passwordRestored');
    }
});
