import React, {Component} from 'react';
import PropTypes from 'prop-types';
import {connect} from 'react-redux';
import {Header} from '@blocks/morda/components/header/header.jsx';
import {Footer} from '@components/Footer/Footer.jsx';
import {NoJS} from '@components/NoJS';
import RestoreLogin from '@blocks/morda/restore_login/restore_login.jsx';

class App extends Component {
    render() {
        const {settings, common, person, header, footer} = this.props;

        return (
            <div className='layout-inner'>
                <NoJS />
                <Header displayName={person.displayName} {...header} {...settings} {...common} />
                <div className='grid'>
                    <RestoreLogin />
                </div>
                <Footer {...settings} {...footer} />
            </div>
        );
    }
}

App.propTypes = {
    common: PropTypes.object.isRequired,
    settings: PropTypes.object.isRequired,
    person: PropTypes.object.isRequired,
    header: PropTypes.object.isRequired,
    footer: PropTypes.object.isRequired,
    location: PropTypes.string
};

export default connect((state) => state)(App);
