import thunkMiddleware from 'redux-thunk';
import {createStore, applyMiddleware, compose, combineReducers} from 'redux';
import reducers from '../../../blocks/react-blocks/restore.login.reducers';

export default function(initialState) {
    const devTools =
        typeof window === 'object' &&
        typeof window.__REDUX_DEVTOOLS_EXTENSION__ !== 'undefined' &&
        process.env.NODE_ENV !== 'production'
            ? window.__REDUX_DEVTOOLS_EXTENSION__()
            : (f) => f;

    return createStore(combineReducers(reducers), initialState, compose(applyMiddleware(thunkMiddleware), devTools));
}
