// блоки паспорта
/* borschik:include:{{RELATIVEROOT}}/blocks/blocks.js */
/* borschik:include:{{RELATIVEROOT}}/blocks/field-hint/field-hint.js */

(function() {
    var nameMap = {
        firstname: 'firstnames',
        lastname: 'lastnames',
        'feedback-email': 'contact_email',
        eula_accepted_confidential: 'eula_accepted',
        'folders-mail': 'email_folders',
        'sender-mail': 'outbound_emails',
        'collector-mail': 'email_collectors',
        'whitelist-mail': 'email_whitelist',
        'blacklist-mail': 'email_blacklist',
        'last-passwords': 'passwords',
        phones: 'phone_numbers',
        'additional-email': 'emails',
        'last-auth': 'password_auth_date',
        'registration-date': 'registration_date'
    };

    Object.keys(passport.blocks).forEach(function(id) {
        var _validate = passport.block('control').validate;
        var block = passport.block(id);

        if (
            block &&
            block.isControl &&
            [
                'attach',
                'submit',
                'services',
                'user-enabled',
                'registration-country',
                'registration-city',
                'answers',
                'questions'
            ].indexOf(id) === -1
        ) {
            if (block.validate !== _validate) {
                block.validate = _validate;
            }

            block.updateTimeout = 0;
            block.validationPath = 'semiauto';
            block.needsServerValidation = true;

            block.getValidationParams = function() {
                var params = {};

                params[nameMap[id] || id] = this.val();
                return params;
            };

            passport.mixins.validateOnFocusout(block);
        }
    });
})();

$(function() {
    passport.block('registration-city').isRequired = false;
    var birthday = passport.block('birthday');

    birthday.isRequired = true;

    passport.init();
    nb.init();

    var $html = $('html');

    if (!$html.hasClass('is-touch') && !$html.hasClass('is-tablet')) {
        $('input[type="text"]:visible')
            .first()
            .focus();
    }
});
