import {createStore, compose, combineReducers, applyMiddleware} from 'redux';
import thunkMiddleware from 'redux-thunk';
import captcha from '@components/Captcha/reducers';
import tracks from '@blocks/reducers/tracks';
import form from '@blocks/reducers/form';

const devTools =
    typeof window === 'object' &&
    typeof window.devToolsExtension !== 'undefined' &&
    process.env.NODE_ENV !== 'production'
        ? window.devToolsExtension()
        : (f) => f;

const stub = (state = {}) => state;

const mainReducer = combineReducers({
    header: stub,
    person: stub,
    footer: stub,
    access: stub,
    common: stub,
    metrics: stub,
    settings: stub,
    social: stub,
    captcha,
    tracks,
    form
});

const configureStore = (state) => createStore(mainReducer, state, compose(applyMiddleware(thunkMiddleware), devTools));

export {configureStore};
