(function() {
    var storageAvailable = function(type) {
        var storage;

        try {
            storage = window[type];
            var x = '__storage_test__';

            storage.setItem(x, x);
            storage.removeItem(x);
            return true;
        } catch (e) {
            return (
                e instanceof DOMException &&
                // everything except Firefox
                (e.code === 22 ||
                    // Firefox
                    e.code === 1014 ||
                    // test name field too, because code might not be present
                    // everything except Firefox
                    e.name === 'QuotaExceededError' ||
                    // Firefox
                    e.name === 'NS_ERROR_DOM_QUOTA_REACHED') &&
                // acknowledge QuotaExceededError only if there's something already stored
                storage &&
                storage.length !== 0
            );
        }
    };

    window.writeToStorage = function(suggest) {
        if (storageAvailable('localStorage')) {
            localStorage.setItem('socialResponse', JSON.stringify({socialSuggest: true, suggest: suggest}));
        } else {
            document.cookie = 'socialParams=' + suggest.trackId + ';path=/;max-age=' + 60 * 60 * 0.5;
            document.cookie = 'process=socialSuggest;path=/;max-age=' + 60 * 60 * 0.5;
        }

        try {
            if (window.opener === null) {
                if (storageAvailable('localStorage')) {
                    localStorage.setItem('process', 'socialSuggest');
                }

                window.location.replace(window.location.origin + '/auth');
                return;
            }

            window.close();
        } catch (error) {
            // TODO экран с ошибкой
            // console.error('error', error);
        }
    };
})();
