// блоки паспорта
/* borschik:include:{{RELATIVEROOT}}/blocks/blocks.js */
/* borschik:include:{{RELATIVEROOT}}/blocks/control/current-question/current-question.js */
/* borschik:include:{{RELATIVEROOT}}/blocks/control/current-answer/current-answer.js */
/* borschik:include:{{RELATIVEROOT}}/blocks/header/dheader.js */

$(function() {
    var headerMetrics = ['Страница mode=unsubscribe'];
    var metricEvent = 'mousedown';

    if ('ontouchstart' in window) {
        metricEvent = 'touchstart';
    }

    function sendMetric(params) {
        if (headerMetrics) {
            passport.Metrika.count(headerMetrics.concat(params));
        }
    }

    passport.block('unsubscribe-block', {
        events: {
            'click .js-show-captcha': 'showCaptchaPopup',
            'phoneConfirmed.phone-confirm': 'showSubmit',
            'answerChecked.current-answer': 'showSubmit',
            'correct.captcha': 'proceedCaptcha'
        },

        init: function() {
            this.captcha = passport.block('captcha');
            this.confirmationType = document.getElementById('current_question') ? 'question' : 'phone';
        },

        showCaptchaPopup: function(event) {
            var that = this;

            event.preventDefault();
            that.captcha.enableCaptcha();
        },

        proceedCaptcha: function(event) {
            this.captcha.closeCaptcha();

            if (this.confirmationType === 'question') {
                passport.block('current-answer').initValidation(event);
            } else {
                passport.block('phone-confirm-entry').initConfirmation(event);
                $('.js-number-is-unavailable').addClass('g-hidden');
            }
        },

        showSubmit: function() {
            $('.goto-support-message').addClass('g-hidden');
            $('.controls-wrap').removeClass('g-hidden');
            $('#current_password').focus();
            sendMetric(['Успешный ввод средства подтверждения']);
        }
    });

    // инициализация блоков паспорта
    // валидации, индикации и т.п.
    passport.init();
    $('input:visible')
        .first()
        .focus();

    $(document).on(metricEvent, '.js-metrics-help-link', function() {
        sendMetric(['Нажатие на Помощь']);
    });

    $(document).on(metricEvent, '.js-metrics-email-unsubscribe', function() {
        sendMetric(['Удаление почты']);
    });
    sendMetric(['Показ страницы']);
});
