(function(window) {
    var location = window.location;
    var whiteList = [
        'ddom',
        'status',
        'task_id',
        'profile.profile_id'
    ];
    // For very very very old IE
    location.origin = location.protocol + "//" + location.hostname;

    function closer() {
        var params = {
            socialAuth: true
        };
        var href;
        var query;

        // location.hash не пустой, и при этом он не равен решетке с подчеркиваниями, тогда берем его
        // location.hash !== '#_=_'
        // грязный хак для Facebook
        if (location.hash && location.hash !== '#_=_') {
            query = location.hash.substr(1).split('&');
        } else {
            query = location.search.substr(1).split('&');
        }

        for (var i = 0; i < query.length; i++) {
            (function(query) {
                var param = query.split('=');
                var key = decodeURIComponent(param[0]);
                var value = decodeURIComponent(param[1]);

                if (whiteList.indexOf(key) > -1 && value.length < 40) {
                    params[key] = value;
                }
            })(query[i]);
        }

        // check if IE11 and refresh page - IE11 can do postMessage only with iframe
        // http://stackoverflow.com/questions/19638981/window-activexobject-difference-in-ie11
        if (!(window.ActiveXObject) && "ActiveXObject" in window) {
            window.opener.socialResponse(params);

            if (typeof window.opener.socialResponseAuthorized === 'function') {
                window.opener.socialResponseAuthorized(params);
            }

        } else {
            if (typeof window.opener === 'undefined') {
                try {
                    window.localStorage.setItem('socialResponse', JSON.stringify(params));
                } catch(e) {}
            } else {
                try {
                    window.opener.postMessage(params, location.origin);
                } catch(e) {
                    window.opener.socialResponse(params);
                }
            }
        }
        window.close();
    }

    function removeURLParameter(url, parameter) {
        //prefer to use l.search if you have a location/link object
        var urlparts= url.split('?');
        if (urlparts.length>=2) {

            var prefix= encodeURIComponent(parameter)+'=';
            var pars= urlparts[1].split(/[&;]/g);

            //reverse iteration as may be destructive
            for (var i= pars.length; i-- > 0;) {
                //idiom for string.startsWith
                if (pars[i].lastIndexOf(prefix, 0) !== -1) {
                    pars.splice(i, 1);
                }
            }

            url= urlparts[0]+'?'+pars.join('&');
            return url;
        } else {
            return url;
        }
    }

    document.body.onload = closer;
})(window);
