const authIntranet = require('./routes/auth_intranet').router;
const blockRoutes = require('./routes/blocks');
const modeLogout = require('./routes/logout');
const modeErrorPage = require('./routes/mode.error').router;
const sessguardSet = require('./routes/sessguard/set').router;
const authUpdate = require('./routes/auth.update.js').router;
const profilePasswordNew = require('./routes/profile.password.new').router;

module.exports = function(app) {
    require('./routes/profile.access').route(app);
    require('./routes/embeddedauth.js').route(app);
    require('./routes/retpath.js').route(app);
    require('./routes/common/multiAuthAccountsSetup').route(app);
    require('./routes/verify.js').route(app);
    modeLogout.route(app);
    app.use('/auth/pulse', (req, res) => {
        if (res.locals.isYandex) {
            return res.status(200).json({
                status: 'ok'
            });
        }

        return res.status(204).send();
    });
    app.use('/passport', modeErrorPage);
    app.use('/auth/secure/?', (req) => req._controller.replaceToAuth());
    app.use('/auth/?', authIntranet);
    app.use(
        '/passport/?',
        function(req, _res, next) {
            if (req.query.mode === 'auth') {
                return next();
            }

            return next('route');
        },
        authIntranet
    );

    // auth/session
    require('./routes/session.js').route(app);
    app.use('/auth/guard/?', authUpdate);
    app.use('/set/?', sessguardSet);
    app.use('/profile/password', profilePasswordNew.common);
    require('./routes/auth.update.js').route(app);
    require('./routes/auth.js').route(app);
    require('./routes/profile.passport.intranet')(app);

    //
    // Routes for field validations
    //
    const whiteListBlockRoutes = [
        'accounts',
        'accounts/forget',
        'accounts/input-login',
        'audiocaptcha',
        'auth/multi_step/commit_password',
        'auth/multi_step/start',
        'auth/multi_step/submit_email_code',
        'captcha',
        'checkHuman',
        'password',
        'getTrackWithUid',
        'phone-confirm-code-submit',
        'rfcTotpRecreateSecret',
        'textcaptcha',
        'validate-firstname',
        'validate-phone'
    ];

    whiteListBlockRoutes.forEach((route) => {
        if (blockRoutes.hasOwnProperty(route)) {
            /*jshint loopfunc:true*/
            (function(blockRoutes, route) {
                app.post(`/registration-validations/${route}/?`, blockRoutes[route]);
                app.options(`/registration-validations/${route}/?`, function(req, res) {
                    res.setHeader('Allow', 'POST');
                    res.send(200);
                });
            })(blockRoutes, route);
        }
    });

    if (['development', 'testing', 'rc'].indexOf(app.get('env')) !== -1) {
        require('./routes/common/debug').route(app);
    }
};
