'use strict';

var express = require('express');
var router = express.Router();
var apiSetup = require('./common/apiSetup');
var PLog = require('plog');

function doTrackDispatch(req, res, next) {
    var trackId = req.params.track_id;
    var data;

    if (!trackId) {
        return next(new Error('track_id is unknown'));
    }

    data = {
        track_id: trackId
    };

    return req.api
        .dispatchTrack(data)
        .then(function(result) {
            var body = result.body;

            if (body.status === 'error') {
                return next(body.errors);
            }

            res.locals.track_id = body.track_id;
            return next();
        })
        .catch(function(err) {
            return next(err);
        });
}

function doSessionRequest(req, res, next) {
    const controller = req._controller;

    var trackId = res.locals.track_id;
    var data;

    if (!trackId) {
        return next(new Error('track_id is unknown'));
    }

    data = {
        track_id: trackId,
        retpath: req.body.retpath
    };

    return req.api
        .bundleSession(data)
        .then(function(result) {
            var body = result.body;

            if (body.status === 'error') {
                return next(body.errors);
            }

            controller.augmentResponse(body);

            if (body.cookies) {
                return req._controller.redirectToLocalUrl({
                    pathname: 'auth/finish',
                    query: {
                        track_id: trackId,
                        retpath: body.retpath
                    }
                });
            }

            return res.redirect(body.retpath);
        })
        .catch(function(err) {
            return next(err);
        });
}

// eslint-disable-next-line no-unused-vars
function errorHandler(err, req, res, next) {
    PLog.warn()
        .logId(req.logID)
        .type('a')
        .write(err);

    return req._controller.redirectToLocalUrl({
        pathname: 'auth'
    });
}

router.use(apiSetup);
router.get('/:track_id/?', doTrackDispatch, doSessionRequest, errorHandler);

module.exports.router = router;
