var url = require('url');
var apiSetup = require('./common/apiSetup');
var util = require('util');
var processErrors = require('../lib/passport-errors').processErrors;

exports.routes = {};

exports.route = function(app) {
    var routes = this.routes;
    var pddRoute = '/for/:pdd_domain/after_restore/?';

    app.get('/auth/after_restore/?', routes.main);
    app.get(pddRoute, routes.main);
};

exports.routes.main = [
    apiSetup,
    doAfterRestore,
    function(error, req, res, next) {
        new (require('../lib/controller'))(req, res, req.logID)
            .getLanguage()
            .then(function(lang) {
                res.locals.language = lang;
            })
            .catch(function(err) {
                res.locals.language = 'ru';
                require('plog')
                    .warn()
                    .logId(req.logID)
                    .type('after restore')
                    .write(err);
            })
            .done(function() {
                return next(error);
            });
    },
    errorHandler
];

exports.getConfig = function() {
    return require('../configs/current');
};

function doAfterRestore(req, res, next) {
    const controller = req._controller;
    var data = {
        track_id: req.nquery && req.nquery.track_id
    };
    var pdd_domain = req.params.pdd_domain || req.body['pdd_domain'] || (req.nquery && req.nquery['pdd_domain']);

    if (pdd_domain) {
        data['is_pdd'] = '1';
    }

    req.api.authSubmit('/1/bundle/auth/after_restore/submit/', data).done(function(results) {
        var body = results.body;
        var target = url.format({
            protocol: req.headers['x-real-scheme'],
            hostname: req.hostname,
            pathname: 'passport',
            query: {
                mode: 'passport'
            }
        });
        var finishPathname;

        controller.augmentResponse(body);

        if (body.cookies && body.cookies.length) {
            finishPathname = '/auth/finish/';

            target = url.format({
                protocol: req.headers['x-real-scheme'],
                hostname: req.hostname,
                pathname: finishPathname,
                query: {
                    track_id: body.track_id
                }
            });
        } else {
            if (body.retpath) {
                target = body.retpath;
            }
        }

        return res.redirect(target);
    }, next);
}

// eslint-disable-next-line no-unused-vars
function errorHandler(err, req, res, next) {
    var lang = res.locals.language;
    var errors = processErrors(['internal'], lang);
    var data;

    if (err && util.isArray(err)) {
        errors = processErrors(err, lang);
    }

    data = {
        title: errors[0].msg,
        messages: [errors[0].mend]
    };

    return res.render(`auth.message.${lang}.js`, data);
}

exports.doAfterRestore = doAfterRestore;
