const rootRoute = require('./../auth.v2').rootRoute;

exports.route = (isDebug) => (app) => {
    app.get(
        '/am',
        (req, res, next) => {
            res.locals.isAmDebug = isDebug;

            next();
        },
        rootRoute
    );
    app.get('/am/finish', function(_, res) {
        return res.status(200).set('X-Frame-Options', 'DENY').send(`<!DOCTYPE html>
                    <html lang="en">
                        <head><meta charset="utf-8" /></head>
                    </html>`);
    });

    if (isDebug) {
        app.get('/am/debug', rootRoute);
    }
};
