const express = require('express');
const router = express.Router();

const langSetup = require('./common/langSetup');
const checkAuth = require('./common/checkAuth');
const getUatraitsData = require('./common/getUatraitsData');
const rumCounterSetup = require('./common/rumCounterSetup');
const writeStatbox = require('./common/writeStatbox');
const getSettings = require('./auth/common/getStore/getSettings');
const getSocial = require('./auth/common/getStore/getSocial');
const getMetrics = require('./common/getMetrics');
const getCaptcha = require('./common/getCaptcha');
const getMonitoring = require('./auth/common/getStore/getMonitoring');
const createState = require('./authv2/createState');
const createAuthState = require('./authv2/createAuthState');
const createCommonState = require('./authv2/createCommonState');
const createCustomsState = require('./common/createCustomsState');
const createAdditionalDataRequestState = require('./authv2/createAdditionalDataRequestState');
const isUnsupportedBro = require('./authv2/isUnsupportedBro');
const prepareStatData = require('./authv2/prepareStatData');
const renderPage = require('./authv2/renderPage');
const getYaExperimentsFlags = require('./common/getYaExperimentsFlags');

const getRoute = [
    checkAuth,
    getUatraitsData,
    (req, res, next) => {
        const ua = res.locals.ua;

        if (req.query.track_id) {
            return next('route');
        }

        if (req.query.new === '0') {
            return next('route');
        }

        if (isUnsupportedBro(ua)) {
            return next('route');
        }

        return next();
    },
    langSetup,
    getYaExperimentsFlags,
    createState,
    createCommonState(),
    getSettings(),
    getSocial(),
    getCaptcha(),
    getMetrics({
        header: 'Доввод данных V2'
    }),
    getMonitoring({
        page: 'auth.ask.v2'
    }),
    createAuthState(),
    createCustomsState,
    createAdditionalDataRequestState(),
    rumCounterSetup,
    prepareStatData,
    writeStatbox({
        action: 'opened',
        mode: '2step_domik'
    }),
    renderPage
];

router.get('/phone', getRoute);
router.get('/email', getRoute);
router.get('/avatar', getRoute);

exports.router = router;
