const apiSetup = require('./common/apiSetup');
const langSetup = require('./common/langSetup');
const writeStatbox = require('./common/writeStatbox');
const getMetrics = require('./common/getMetrics');
const rumCounterSetup = require('./common/rumCounterSetup');
const getUatraitsData = require('./common/getUatraitsData');

const apiRequest = require('./authv2/apiRequest');

const renderPage = require('./authSilent/renderPage');
const createStore = require('./authSilent/createStore');

const express = require('express');
const router = express.Router();

const rootRoute = [
    apiSetup,
    langSetup,
    apiRequest('validateRetpath'),
    getUatraitsData,
    createStore,
    writeStatbox({
        action: 'opened',
        mode: 'auth_silent'
    }),
    getMetrics({
        header: 'Авторизация silent'
    }),
    rumCounterSetup,
    renderPage
];

router.get('/', rootRoute);

exports.router = router;
