const express = require('express');
const router = express.Router();
const PLog = require('plog');
const url = require('url');

const apiSetup = require('./common/apiSetup');
const langSetup = require('./common/langSetup');
const writeStatbox = require('./common/writeStatbox');
const getMetrics = require('./common/getMetrics');
const rumCounterSetup = require('./common/rumCounterSetup');
const apiRequest = require('./authv2/apiRequest');

const config = require('../configs/current');

function renderPage(req, res) {
    const locals = res.locals;
    const lang = locals.language;

    res.render(`react.auth-smarttv.${lang}.jsx`);
}

const isDevOrTesting = ['testing', 'development'].includes(process.env.NODE_ENV);
const SECOND_DESIGN_VERSION_ORIGINS = ['ya_smart_device'];

module.exports = (app) => {
    router.get('/', [
        apiSetup,
        langSetup,
        (req, res, next) => {
            // новый параметр для authPasswordSubmit, нужен не всегда
            // https://st.yandex-team.ru/PASSP-24684
            res.withCode = true;

            return next();
        },
        apiRequest('authPasswordSubmit'),
        apiRequest('validateRetpath'),
        (req, res, next) => {
            const locals = res.locals;
            const apiRequestsResult = locals.result || {};
            const {authPasswordSubmit = {}, validateRetpath = {}} = apiRequestsResult;
            const {user_code: userCode} = authPasswordSubmit;
            const {userType = {}} = locals;
            const {version, paths = {}} = config;
            const {static: staticPath} = paths;
            const {metricsUserType} = userType;

            locals.store = {
                settings: {
                    version,
                    metricsUserType,
                    staticPath,
                    lang: locals.language,
                    tld: req._controller.getTld()
                },
                userCode,
                csrf: locals.csrf,
                isNoQrScreen: req.query.noQr === '1',
                willShowSkipButton: req.query.skip === '1',
                isSecondDesignVersion: SECOND_DESIGN_VERSION_ORIGINS.includes(req.query.origin)
            };

            if (validateRetpath.retpath) {
                locals.store.retpath = validateRetpath.retpath;
            } else {
                locals.store.retpath = url.format({
                    pathname: '/profile',
                    query: req.query
                });
            }

            next();
        },
        (req, res, next) => {
            const {locals: {result: {authPasswordSubmit} = {}} = {}} = res;
            const {track_id: trackId = ''} = authPasswordSubmit;
            const {query: {origin = ''} = {}} = req;

            if (origin === 'ya_smart_device' && trackId) {
                req.api
                    .writeTrack({
                        track_id: trackId,
                        device_name: `${origin}_device_name`
                    })
                    .then((res) => {
                        const {body: {id = ''} = {}} = res;

                        authPasswordSubmit.track_id = id;

                        return next();
                    })
                    .catch((error) => {
                        PLog.warn()
                            .logId(req.logID)
                            .type('auth-smarttv, writeTrackDeviceName')
                            .write(error);
                        return next();
                    });
            } else {
                return next();
            }
        },
        (req, res, next) => {
            const locals = res.locals;
            const {query = {}} = req;
            const {csrfTokenDebug} = query;
            const authPasswordSubmit = locals.result.authPasswordSubmit;

            if (!authPasswordSubmit) {
                locals.store.error = 'internal';
                locals.store.trackId = '';
                locals.store.csrfToken = '';

                return next();
            }

            locals.store.trackId = authPasswordSubmit.track_id;
            locals.store.csrfToken = authPasswordSubmit.csrf_token;

            if (isDevOrTesting && csrfTokenDebug) {
                locals.store.csrfToken = csrfTokenDebug;
            }

            return next();
        },
        (req, res, next) => {
            res.removeHeader('X-Frame-Options');

            res.locals.preparedStat = {
                track_id: res.locals.store.trackId
            };

            next();
        },
        writeStatbox({
            action: 'opened',
            mode: 'auth_smarttv'
        }),
        getMetrics({header: 'Авторизация SmartTV'}),
        rumCounterSetup,
        renderPage,
        // eslint-disable-next-line no-unused-vars
        (error, req, res, next) => {
            PLog.warn()
                .logId(req.logID)
                .type('auth smarttv error')
                .write(error);

            if (!res.locals.store) {
                res.locals.store = {};
            }

            res.locals.store.error = error.message;

            return renderPage(req, res);
        }
    ]);

    if (['development', 'testing', 'rc'].indexOf(app.get('env')) !== -1) {
        router.get('/frame', [
            (req, res) => {
                res.send(`
                    <iframe style="width: 700px; height: 700px;" src="https://${req.hostname}/auth/smarttv">
                    </iframe>
                `);
            }
        ]);
    }

    return router;
};
