const express = require('express');
const router = express.Router();
const langSetup = require('./common/langSetup');
const apiSetup = require('./common/apiSetup');
const {expFilter} = require('./common/expFilter');
const getUatraitsData = require('./common/getUatraitsData');
const rumCounterSetup = require('./common/rumCounterSetup');
const writeStatbox = require('./common/writeStatbox');
const getSettings = require('./auth/common/getStore/getSettings');
const getSocial = require('./auth/common/getStore/getSocial');
const getMetrics = require('./common/getMetrics');
const {getQuestions} = require('./common/loadQuestions');
const getCaptcha = require('./common/getCaptcha');
const getMonitoring = require('./auth/common/getStore/getMonitoring');
const createState = require('./authv2/createState');
const {maybeRunAuthVerify} = require('./authv2/authVerify');
const createAuthState = require('./authv2/createAuthState');
const {magicBookSetup} = require('./authv2/magicBookSetup');
const createRestoreLoginState = require('./authv2/restoreLogin/createRestoreLoginState');
const createMobileMenuState = require('./authv2/createMobileMenuState');
const createPagePopupState = require('./authv2/createPagePopupState');
const createCommonState = require('./authv2/createCommonState');
const createCustomsState = require('./common/createCustomsState');
const createChallengeState = require('./authv2/createChallengeState');
const createMailAuthState = require('./authv2/createMailAuthState');
const createMessengerAuthState = require('./authv2/createMessengerAuthState');
const createAMState = require('./authv2/createAMState');
const validateAMParams = require('./authv2/validateAMParams');
const getYaExperimentsFlags = require('./common/getYaExperimentsFlags');
const isUnsupportedBro = require('./common/isUnsupportedBro');
const prepareStatData = require('./authv2/prepareStatData');
const chooseMode = require('./authv2/chooseMode');
const renderPage = require('./authv2/renderPage');
const generateProcessUUID = require('./authv2/generateProcessUUID');
const multiStepAuthStart = require('./authv2/multiStepAuthStart');
const setPreRegisterExperiment = require('./authv2/setPreRegisterExperiment');
const setRegisterInDaHouseExperiment = require('./authv2/setRegisterInDaHouseExperiment');
const setRestoreLoginCallsExperiment = require('./authv2/restoreLogin/setRestoreLoginCallsExperiment');
const setDefaultTextsExperiment = require('./authv2/setDefaultTextsExperiment');
const setWelcomePageTitleExperiment = require('./authv2/setWelcomePageTitleExperiment');
const setAuthButtonAndTextExperiment = require('./authv2/setAuthButtonAndTextExperiment');
const checkAuth = require('./common/checkAuth');
const createPhoneConfirmState = require('./authv2/createPhoneConfirmState');
const restorePassword = require('./authv2/restorePassword/restorePassword');
const restorePasswordCaptcha = require('./authv2/restorePassword/restorePasswordCaptcha');
const handleExternalLinks = require('./authv2/restorePassword/handleExternalLinks');
const createSignUpState = require('./common/createSignUpState');
const createFormState = require('./common/createFormState');
const {loadQuestions} = require('./common/loadQuestions');
const createChangePasswordState = require('./authv2/changePassword/createChangePasswordState');
const setRegExperiments = require('./registration/setRegExperiments');
const checkSms2faChallenge = require('./authv2/challenge/checkSms2faChallenge');
const setTheme = require('./authv2/setTheme');
const setDisplay = require('./authv2/setDisplay');
const {maybeRunForRegComplete, regComplete} = require('./authv2/regComplete');
const {AUTH_REG_COMPLETE_LOG_TYPE} = require('./authRegComplete/constants');

const rootRoute = [
    apiSetup,
    getUatraitsData,
    (req, res, next) => {
        const ua = res.locals.ua;

        if (req.query.track_id) {
            return next('route');
        }

        if (req.query.new === '0') {
            return next('route');
        }

        if (isUnsupportedBro(ua)) {
            return next('route');
        }

        return next();
    },
    generateProcessUUID,
    langSetup,
    getYaExperimentsFlags,
    createState,
    createAuthState(),
    chooseMode,
    maybeRunForRegComplete(getQuestions(AUTH_REG_COMPLETE_LOG_TYPE)),
    createCommonState(),
    createFormState,
    maybeRunAuthVerify(),
    createSignUpState,
    createChangePasswordState,
    getSettings(),
    getSocial(),
    getCaptcha(),
    getMetrics({
        header: 'Авторизация'
    }),
    getMonitoring({
        page: 'auth.v2'
    }),
    createMobileMenuState,
    createPagePopupState,
    createCustomsState,
    magicBookSetup(),
    rumCounterSetup,
    regComplete(),
    multiStepAuthStart.middleware,
    prepareStatData,
    writeStatbox({
        action: 'opened',
        mode: '2step_domik'
    }),
    createMailAuthState,
    createMessengerAuthState,
    setPreRegisterExperiment,
    setRegisterInDaHouseExperiment,
    setRestoreLoginCallsExperiment,
    setDefaultTextsExperiment,
    setWelcomePageTitleExperiment,
    setAuthButtonAndTextExperiment,
    setRegExperiments,
    validateAMParams,
    createAMState,
    createPhoneConfirmState,
    setTheme,
    renderPage
];

const childishEnter = [
    checkAuth,
    getYaExperimentsFlags,
    function checkExp(req, res, next) {
        if (req._controller.hasExp('profile-family-childish-exp')) {
            return next();
        }

        return next('route');
    },
    rootRoute
];

const restoreLoginRoute = [
    apiSetup,
    getUatraitsData,
    (req, res, next) => {
        const ua = res.locals.ua;

        if (req.query.track_id) {
            return next('route');
        }

        if (req.query.new === '0') {
            return next('route');
        }

        if (isUnsupportedBro(ua)) {
            return req._controller.redirectToLocalUrl({
                pathname: 'restoration/login'
            });
        }

        return next();
    },
    generateProcessUUID,
    langSetup,
    getYaExperimentsFlags,
    createState,
    createCommonState(),
    getSettings(),
    getSocial(),
    getCaptcha(),
    getMetrics({
        header: 'Восстановление логина на авторизации'
    }),
    getMonitoring({
        page: 'auth.v2'
    }),
    createAuthState(),
    createMobileMenuState,
    createPagePopupState,
    createCustomsState,
    rumCounterSetup,
    createRestoreLoginState,
    prepareStatData,
    writeStatbox({
        action: 'opened',
        mode: '2step_domik_restore_login'
    }),
    createMailAuthState,
    setPreRegisterExperiment,
    setRestoreLoginCallsExperiment,
    setDefaultTextsExperiment,
    setWelcomePageTitleExperiment,
    setAuthButtonAndTextExperiment,
    setTheme,
    renderPage
];

const regLiteRoute = [
    apiSetup,
    function(req) {
        return req._controller.redirectToLocalUrl({
            pathname: '/auth/preregister',
            query: req.query
        });
    }
];

const challengeRoute = [
    apiSetup,
    getUatraitsData,
    (req, res, next) => {
        const ua = res.locals.ua;

        if (req.query.new === '0') {
            return next('route');
        }

        if (isUnsupportedBro(ua)) {
            return next('route');
        }

        return next();
    },
    generateProcessUUID,
    langSetup,
    getYaExperimentsFlags,
    createState,
    createCommonState(),
    getSettings(),
    getSocial(),
    getCaptcha(),
    getMetrics({
        header: 'Челлендж на авторизации'
    }),
    getMonitoring({
        page: 'auth.v2'
    }),
    createAuthState(),
    createMobileMenuState,
    createPagePopupState,
    createCustomsState,
    rumCounterSetup,
    chooseMode,
    prepareStatData,
    writeStatbox({
        action: 'opened',
        mode: '2step_domik_challenge'
    }),
    createMailAuthState,
    createMessengerAuthState,
    checkSms2faChallenge,
    createChallengeState,
    setPreRegisterExperiment,
    setRestoreLoginCallsExperiment,
    setDefaultTextsExperiment,
    setWelcomePageTitleExperiment,
    setAuthButtonAndTextExperiment,
    setDisplay,
    setTheme,
    renderPage
];

const checkRegAccess = [
    getUatraitsData,
    (req, res, next) => {
        const {ua} = res.locals;

        if (isUnsupportedBro(ua)) {
            return req._controller.redirectToRegistration();
        }

        return next();
    }
];

router.get('/', rootRoute);
router.get('/verify/?', [checkAuth, expFilter({include: 'new-auth-verify-design'}), ...rootRoute]);
router.get('/child/restrict', childishEnter);
router.get('/child/change', childishEnter);
router.get('/child/exit', childishEnter);
router.get('/child/add', childishEnter);
router.get('/magic', rootRoute);
router.get('/add', rootRoute);
router.get('/list', rootRoute);
router.get('/welcome', rootRoute);
router.get('/preregister', rootRoute);
router.get('/register/lite', regLiteRoute);
router.get('/challenge', challengeRoute);
router.get('/complete', rootRoute);
router.get('/restore/login', restoreLoginRoute);
router.get('/restore/neo', restoreLoginRoute);
router.get('/phoneconfirm', [checkAuth].concat(rootRoute));
router.get('/reg', checkRegAccess, [loadQuestions, ...rootRoute]);
router.post('/reg', checkRegAccess, rootRoute);
router.get('/changepassword', rootRoute);
router.get('/social-suggest', rootRoute);

router.post(
    '/autologin',
    function(req, res, next) {
        req.isBroAutologin = true;
        return next();
    },
    rootRoute
);

router.get(
    '/restore/password(/bind-phone-confirm|/notify|/method|/method-confirm|/bind-phone|/bind-hint|/finish)?',
    restorePassword
);
router.get('/restore', handleExternalLinks);
router.get('/restore/password/captcha', restorePasswordCaptcha);

exports.router = router;
exports.rootRoute = rootRoute;
