const PLog = require('plog');
const processField = require('../../embeddedauth').processField;

module.exports = function apiRequest(apiMethod) {
    return function(req, res, next) {
        const data = Object.assign({}, req.query, req.body);
        const controller = req._controller;

        Object.keys(data).forEach(function(field) {
            data[field] = processField(data[field]);
        });

        if (apiMethod === 'validateRetpath' && !data.retpath) {
            return next();
        }

        if (apiMethod === 'validateBackpath' && !data.backpath) {
            return next();
        }

        if (apiMethod === 'authSuggestForget') {
            data.uid = data._uid;
            delete data._uid;
        }

        if (apiMethod === 'authSuggestGetInputLogin') {
            data.uid = data._uid;
            delete data._uid;
        }

        if (apiMethod === 'authPasswordSubmit') {
            if (res.trackId) {
                req.api.track(res.trackId);
                data.track_id = res.trackId;
            }

            delete data._uid;
        }

        return controller._getApiPromise().then(function(api) {
            api[apiMethod](data)
                .then(function(result) {
                    const body = result.body;
                    const sendToLocals = {};

                    sendToLocals[apiMethod] = body;
                    res.locals.result = Object.assign({}, res.locals.result, sendToLocals);
                    controller.augmentResponse(body);

                    return next();
                })
                .catch(function(errors) {
                    PLog.warn()
                        .logId(req.logID)
                        .type(`auth.common.apiRequest.${apiMethod}`)
                        .write(errors);

                    if (apiMethod === 'authPasswordSubmit') {
                        return next(errors);
                    }

                    return next();
                });
        });
    };
};
