module.exports = function chooseMode(req, res, next) {
    const oneDomik = res.locals.store.one_domik;
    const requestedUid = req.body.uid || req.query.uid || null;
    const requestedLogin = req.body.login || req.query.login || null;
    const requestedMode = req.body.mode || req.query.mode || null;

    const hasUnitedAccounts = Object.keys(oneDomik.unitedAccounts).length !== 0;
    const hasAuthorizedAccounts = Object.keys(oneDomik.authorizedAccounts).length !== 0;
    const hasSuggestedAccounts = Object.keys(oneDomik.suggestedAccounts).length !== 0;
    const hasOnlyOneSuggestedAccount = !hasAuthorizedAccounts && Object.keys(oneDomik.suggestedAccounts).length === 1;

    let mode = '';

    // if (req.url !== '/') {
    //     return next();
    // }

    if (requestedMode === 'add-user') {
        res.locals.mode = 'addingAccount';
        return next();
    }

    if (res.state === 'rfc_totp') {
        res.locals.mode = 'rfc_totp';
        return next();
    }

    if (requestedMode === 'qr') {
        res.locals.mode = 'magic';
        return next();
    }

    if (hasUnitedAccounts && Object.keys(oneDomik.unitedAccounts).length > 0) {
        mode = 'edit';
    }

    if (hasUnitedAccounts && hasOnlyOneSuggestedAccount && !requestedUid) {
        mode = 'welcome';
    }

    if (requestedUid) {
        if (hasSuggestedAccounts) {
            oneDomik.suggestedAccounts.forEach(function(acc) {
                const account = acc.account;

                if (
                    account &&
                    String(account.uid) === requestedUid &&
                    oneDomik.unitedAccounts[account.uid].status !== 'VALID'
                ) {
                    mode = 'welcome';
                }
            });
        }

        if (hasUnitedAccounts) {
            Object.keys(oneDomik.unitedAccounts).forEach(function(uid) {
                const account = oneDomik.unitedAccounts[uid];

                if (
                    account &&
                    String(account.uid) === requestedUid &&
                    oneDomik.unitedAccounts[account.uid].status === 'VALID'
                ) {
                    mode = 'edit';
                }
            });
        }
    }

    if (requestedLogin) {
        mode = 'addingAccount';
        if (hasUnitedAccounts) {
            Object.keys(oneDomik.unitedAccounts).forEach(function(uid) {
                const account = oneDomik.unitedAccounts[uid];

                if (account && String(account.login) === requestedLogin) {
                    mode = 'welcome';
                }
            });
        }
    }

    if (!mode) {
        mode = 'addingAccount';
    }

    res.locals.mode = mode;
    return next();
};
