const _ = require('lodash');
const url = require('url');
const config = require('../../../../configs/current');
const getMDAOptions = require('../../../common/getMDAOptions.js');

const apiRequest = require('../apiRequest.js');

module.exports = function getCommon() {
    return [
        apiRequest('authPasswordSubmit'),
        apiRequest('validateRetpath'),
        apiRequest('validateBackpath'),
        (req, res, next) => {
            const storeDraft = res.locals.store || (res.locals.store = {});
            const resultStore = storeDraft.common || (storeDraft.common = {});
            const yu = res._yandexuid && res._yandexuid.replace(/[^0-9]/g, '');
            const currentUrl = url.format(req._controller.getUrl());
            const bgNumber = String((Math.floor(new Date().getTime() / 1000 / 60 / 10) % 18) + 1);
            const experiments = res.locals.experiments;
            const csrf = res.locals.csrf;
            const apiRequestsResult = res.locals.result || {};

            const tld = req._controller.getTld();
            const currentUrlObj = url.parse(url.format(req._controller.getUrl()), true);
            const needMDA = req.cookies.mda === '1';
            const queryToPass = _.pick(req.query, ['clean', 'fretpath', 'from', 'origin']);
            const embeddedauthPath = config.paths.embeddedauth.replace('%tld%', needMDA ? 'ru' : tld);
            const embeddedAuthUrlObj = url.parse(embeddedauthPath, true);

            const trackId = apiRequestsResult.authPasswordSubmit && apiRequestsResult.authPasswordSubmit.track_id;

            const magicCsrfToken =
                apiRequestsResult.authPasswordSubmit && apiRequestsResult.authPasswordSubmit.csrf_token;
            const noreturn = req.query.noreturn === '1';

            let retpath;

            let backpath;

            if (apiRequestsResult.validateRetpath && apiRequestsResult.validateRetpath.retpath) {
                backpath = retpath = apiRequestsResult.validateRetpath.retpath;
                const mdaOptions = getMDAOptions(retpath);

                if (mdaOptions.needMDA) {
                    retpath = mdaOptions.redirectUrl;
                }

                queryToPass.retpath = retpath;
            }

            if (apiRequestsResult.validateBackpath && apiRequestsResult.validateBackpath.retpath) {
                backpath = apiRequestsResult.validateBackpath.retpath;
            }

            if (noreturn) {
                backpath = null;
            }

            Object.assign(
                resultStore,
                {
                    backpath,
                    bgNumber,
                    csrf,
                    currentUrl,
                    experiments,
                    retpath,
                    track_id: trackId,
                    magic_csrf_token: magicCsrfToken,
                    yu,
                    clean: queryToPass.clean,
                    fretpath: queryToPass.fretpath,
                    origin: queryToPass.origin,
                    from: queryToPass.from
                },
                {
                    backPane: null,
                    loginStatusRetpath: `https://${req.hostname}/auth/login-status_v2.html`,
                    embeddedauth_url: url.format(embeddedAuthUrlObj),
                    embeddedAuthUrlObjs: embeddedAuthUrlObj,
                    currentUrl: url.format(currentUrlObj),
                    addUserUrl: url.parse(
                        url.format(
                            Object.assign({}, currentUrlObj, {
                                search: null,
                                pathname: '/auth/add'
                            })
                        )
                    ).path,
                    welcomeUrl: url.parse(
                        url.format(
                            Object.assign({}, currentUrlObj, {
                                search: null,
                                pathname: '/auth/welcome'
                            })
                        )
                    ).path,
                    askPhoneUrl: url.parse(
                        url.format(
                            Object.assign({}, currentUrlObj, {
                                search: null,
                                pathname: '/auth/phone'
                            })
                        )
                    ).path,
                    askAvatarUrl: url.parse(
                        url.format(
                            Object.assign({}, currentUrlObj, {
                                search: null,
                                pathname: '/auth/avatar'
                            })
                        )
                    ).path,
                    askSocialUrl: url.parse(
                        url.format(
                            Object.assign({}, currentUrlObj, {
                                search: null,
                                pathname: '/auth/social'
                            })
                        )
                    ).path,
                    askEmailUrl: url.parse(
                        url.format(
                            Object.assign({}, currentUrlObj, {
                                search: null,
                                pathname: '/auth/email'
                            })
                        )
                    ).path,
                    editUrl: url.parse(
                        url.format(
                            Object.assign({}, currentUrlObj, {
                                search: null,
                                pathname: '/auth/list',
                                query: Object.assign({}, currentUrlObj.query, {
                                    mode: 'edit'
                                })
                            })
                        )
                    ).path,
                    magicUrl: url.parse(
                        url.format(
                            Object.assign({}, currentUrlObj, {
                                search: null,
                                pathname: '/auth/magic'
                            })
                        )
                    ).path,
                    auth_url: url.format(
                        _.extend({}, currentUrlObj, {
                            pathname: '/auth',
                            query: queryToPass
                        })
                    ),
                    changeDefaultUrlObj: _.extend({}, embeddedAuthUrlObj, {
                        search: null,
                        query: {
                            action: 'change_default',
                            yu
                        }
                    }),
                    multilogoutUrlObj: _.extend({}, embeddedAuthUrlObj, {
                        search: null,
                        query: {
                            action: 'logout',
                            yu
                        }
                    }),
                    profile_url: url.format(
                        _.extend({}, currentUrlObj, {
                            pathname: 'profile',
                            search: null,
                            query: queryToPass
                        })
                    ),
                    yandex_url: `https://yandex.${tld}`,
                    restoration_url: url.format(
                        _.extend({}, currentUrlObj, {
                            pathname: 'restoration',
                            search: null,
                            query: queryToPass
                        })
                    ),
                    registration_url: url.format(
                        _.extend({}, currentUrlObj, {
                            pathname: 'registration',
                            search: null,
                            query: queryToPass
                        })
                    )
                }
            );

            return next();
        }
    ];
};
