function getCustomsByOrigin(req, res, next) {
    const storeDraft = res.locals.store || (res.locals.store = {});
    const origin = req.query.origin || req.body.origin;
    const social = req.query.social || req.body.social;
    const resultStore = storeDraft.customs || (storeDraft.customs = {});

    if (social === 'extended') {
        resultStore.socialExtended = true;
    }

    if (origin && typeof origin === 'string' && storeDraft) {
        storeDraft.common.origin = origin;

        if (origin === 'serp_touch_org_ugc' || origin === 'serp_sideblock_org_ugc') {
            resultStore.socialExtended = true;
            resultStore.tagline = 'serp_ugc';
        }

        if (
            [
                'serp_desktop_auth_new',
                'serp_desktop_auth_new_exp',
                'serp_touch_auth',
                'serp_touch_footer',
                'serp_touch_smart_banner',
                'images_touch_auth',
                'images_head_auth'
            ].indexOf(origin) !== -1
        ) {
            resultStore.socialExtended = true;
            resultStore.tagline = 'serp_default';
        }

        if (['video_touch_auth', 'video_head_auth'].indexOf(origin) !== -1) {
            resultStore.socialExtended = true;
            resultStore.tagline = 'video';
        }

        if (['video_touch_auth'].indexOf(origin) !== -1) {
            resultStore.socialExtended = true;
            resultStore.tagline = 'video';
        }

        if (['video_myvideo_add_new'].indexOf(origin) !== -1) {
            resultStore.socialExtended = true;
            resultStore.tagline = origin;
        }

        if (['tune_suggest'].indexOf(origin) !== -1) {
            resultStore.socialExtended = true;
            resultStore.tagline = 'tune';
        }

        if (origin === 'health') {
            resultStore.tagline = 'health';
            storeDraft.common.bgNumber = '200';
            resultStore.socialExtended = true;
        }

        if (origin === 'serp_disk') {
            resultStore.tagline = 'serp_disk';
        }

        if (
            origin === 'mail_hostroot_auth_etalon' ||
            origin === 'mail_hostroot_auth_experiment' ||
            origin === 'hostroot_auth_etalon' ||
            origin === 'hostroot_auth_experiment'
        ) {
            resultStore.tagline = 'mail_exp';
        }

        if (origin === 'audience') {
            resultStore.tagline = 'audience';
        }

        if (origin === 'toloka') {
            resultStore.tagline = 'toloka';
        }

        if (origin === 'money_offer') {
            resultStore.tagline = 'money_offer';
        }

        if (/^music_|^music$|^radio$/.test(origin)) {
            resultStore.socialExtended = true;
            resultStore.socialScope = {
                fb: 'user_friends,user_birthday,public_profile,email,user_likes',
                vk: 'offline,audio,friends'
            };
            storeDraft.common.bgNumber = '100';
            storeDraft.social.providers.forEach(function(provider) {
                if (provider.id === 6) {
                    provider.primary = false;
                }
            });
        }

        if (
            origin === 'maps_favorites' ||
            origin === 'maps_feedback' ||
            origin === 'mapsconstructor' ||
            origin === 'mapsconstructor_new' ||
            origin === 'maps_reviews'
        ) {
            storeDraft.common.bgNumber = `30${String((Math.floor(new Date().getTime() / 1000 / 60 / 10) % 7) + 1)}`;
            resultStore.tagline = origin;
        }

        if (origin === 'mapsconstructor') {
            resultStore.tagline = '';
        }

        if (/^money_/.test(origin) || origin === 'money') {
            storeDraft.common.bgNumber = '401';
        }

        if (origin === 'money_payment') {
            resultStore.tagline = origin;
            storeDraft.common.bgNumber = '402';
        }

        if (origin === 'money_card') {
            resultStore.tagline = origin;
            storeDraft.common.bgNumber = '403';
        }

        if (origin === 'news_welcome1' || origin === 'news_welcome2') {
            resultStore.tagline = origin;
            resultStore.socialExtended = true;
            storeDraft.common.bgNumber = `50${String((Math.floor(new Date().getTime() / 1000 / 60 / 10) % 3) + 1)}`;
        }

        if (origin === 'telephony') {
            resultStore.tagline = origin;
            storeDraft.common.bgNumber = `60${String((Math.floor(new Date().getTime() / 1000 / 60 / 10) % 2) + 1)}`;
        }

        if (origin === 'afisha') {
            resultStore.socialExtended = true;
            storeDraft.common.bgNumber = '700';
        }

        if (origin === 'connect') {
            storeDraft.common.bgNumber = '800';
            resultStore.minimal = true;
            resultStore.tagline = origin;
        }

        if (
            [
                'disk_public-touch-copy',
                'disk_public-android-copy',
                'disk_public-touch-copy-limit',
                'disk_public-touch-comment',
                'disk_public-android-comment'
            ].indexOf(origin) !== -1
        ) {
            resultStore.tagline = origin;
        }

        if (/^disk_/.test(origin)) {
            storeDraft.common.bgNumber = `90${String((Math.floor(new Date().getTime() / 1000 / 60 / 10) % 8) + 1)}`;
        }

        if (
            [
                'market_desktop_review',
                'market_desktop_wishlist',
                'market_desktop_compare',
                'market_desktop_header',
                'market_desktop_forum',
                'market_desktop_comment',
                'market_desktop_checkout'
            ].indexOf(origin) !== -1
        ) {
            resultStore.tagline = origin;
        }

        if (/^market_/.test(origin)) {
            storeDraft.common.bgNumber = '1100';
        }

        if (/^realty/.test(origin)) {
            storeDraft.common.bgNumber = '1200';
        }

        if (/^avia/.test(origin)) {
            storeDraft.common.bgNumber = `130${String((Math.floor(new Date().getTime() / 1000 / 60 / 10) % 3) + 1)}`;
            resultStore.socialExtended = true;
        }

        if (origin === 'passport_device') {
            storeDraft.common.bgNumber = '1400';
            resultStore.tagline = origin;
        }

        if (/^pogoda/.test(origin)) {
            storeDraft.common.bgNumber = '1500';
        }

        if (/^xml/.test(origin)) {
            storeDraft.common.bgNumber = `160${String((Math.floor(new Date().getTime() / 1000 / 60 / 10) % 4) + 1)}`;
        }

        if (/^webmaster/.test(origin)) {
            storeDraft.common.bgNumber = `170${String((Math.floor(new Date().getTime() / 1000 / 60 / 10) % 3) + 1)}`;
        }

        if (/^zen/.test(origin)) {
            storeDraft.common.bgNumber = '1800';
            resultStore.tagline = origin;
            resultStore.socialExtended = true;
        }

        if (origin === 'appmetrica') {
            storeDraft.common.bgNumber = '1900';
            resultStore.tagline = origin;
        }

        if (origin === 'znatoki') {
            storeDraft.customs.tagline = origin;
        }

        if (origin === 'plus' || origin === 'plus_gift') {
            storeDraft.common.bgNumber = `200${String((Math.floor(new Date().getTime() / 1000 / 60 / 10) % 6) + 1)}`;
        }

        if (origin === 'plus_gift') {
            resultStore.tagline = origin;
        }

        if (origin === 'plus_1year') {
            resultStore.tagline = origin;
            storeDraft.common.bgNumber = '2900';
        }

        if (origin === 'beru') {
            storeDraft.common.bgNumber = '2100';
        }

        if (origin === 'lyceum') {
            resultStore.tagline = origin;
            resultStore.socialExtended = true;
            storeDraft.common.bgNumber = `220${String((Math.floor(new Date().getTime() / 1000 / 60 / 10) % 2) + 1)}`;
        }

        if (origin === 'lyceum_ns') {
            resultStore.tagline = 'lyceum';
            storeDraft.common.bgNumber = `220${String((Math.floor(new Date().getTime() / 1000 / 60 / 10) % 2) + 1)}`;
        }

        if (origin === 'contest') {
            resultStore.tagline = origin;
            resultStore.socialExtended = true;
            storeDraft.common.bgNumber = `230${String((Math.floor(new Date().getTime() / 1000 / 60 / 10) % 2) + 1)}`;
        }

        if (origin === 'kinopoisk') {
            resultStore.socialExtended = true;
        }

        if (origin === 'market_cashback') {
            resultStore.tagline = origin;
        }
    }

    return next();
}

module.exports = getCustomsByOrigin;
