const PLog = require('plog');
const apiRequest = require('../apiRequest.js');
const apiSetup = require('../../../common/apiSetup');
const multiAuthAccountsSetup = require('../../../common/multiAuthAccountsSetup').getAccounts;

const authSuggestGetInputLogin = [
    apiSetup,
    function(req, res, next) {
        const suggestedAccounts = res.locals.result.authSuggest && res.locals.result.authSuggest.accounts;
        const uid = Array.isArray(suggestedAccounts) && suggestedAccounts[0] && suggestedAccounts[0].account.uid;

        if (!uid) {
            return next();
        }

        if (!suggestedAccounts || (Array.isArray(suggestedAccounts) && suggestedAccounts.length > 1)) {
            return next();
        }

        return req.api
            .authSuggestGetInputLogin({
                uid
            })
            .then(function(result) {
                if (!res.locals.result.authSuggestGetInputLogin) {
                    res.locals.result.authSuggestGetInputLogin = {};
                }

                res.locals.result.authSuggestGetInputLogin[uid] = result.body.input_login;
                return next();
            })
            .catch(function(err) {
                PLog.warn()
                    .logId(req.logID)
                    .type('auth.common.getStore.getOneDomik.authSuggestGetInputLogin')
                    .write(err);

                return next();
            });
    }
];

module.exports = function getOneDomik() {
    return [
        multiAuthAccountsSetup,
        apiRequest('authSuggest'),
        authSuggestGetInputLogin,
        (req, res, next) => {
            const storeDraft = res.locals.store || (res.locals.store = {});
            const resultStore = storeDraft.one_domik || (storeDraft.one_domik = {});

            const apiRequestsResult = res.locals.result || {};
            const bbRequestsResult = res.locals.accounts;

            const pddDomain = res.locals.pdd_domain || req.body.pdd_domain || req.query.pdd_domain;
            const requestedUid = req.body.uid || req.query.uid || null;

            const captchaIsEmpty = true;
            const formIsSubmitted = false;
            const formIsUpgraded = false;
            const isAccountListEditing = false;
            const isExpanded = false;
            const loginIsEmpty = true;
            const passwordIsEmpty = true;
            const passwordType = 'password';
            const submitCounter = 0;
            const unitedAccounts = {};

            let authorizedAccounts = [];

            let authorizedAccountsDefaultUid = null;

            let canAddMore = true;

            let captchaRequired = false;

            let defaultAccount = null;

            let needEmpty = false;

            let processedAccount = null;
            const method = 'password';

            const form = {
                login: '',
                password: '',
                captcha_answer: '',
                pdd_domain: pddDomain
            };

            let errors;

            if (bbRequestsResult) {
                authorizedAccounts = bbRequestsResult.accounts;
                authorizedAccountsDefaultUid = bbRequestsResult.default_uid;
                canAddMore = bbRequestsResult['can-add-more'];

                bbRequestsResult.accounts.forEach(function(acc) {
                    unitedAccounts[acc.uid] = acc;
                });
            }

            const suggestedAccounts = (apiRequestsResult.authSuggest && apiRequestsResult.authSuggest.accounts) || [];

            const inputLogins = apiRequestsResult.authSuggestGetInputLogin || null;

            if (suggestedAccounts.length) {
                suggestedAccounts.forEach(function(acc) {
                    const account = acc.account;

                    if (unitedAccounts[account.uid]) {
                        return;
                    }

                    if (pddDomain && account.login && account.login.search(pddDomain) === -1) {
                        return;
                    }

                    unitedAccounts[account.uid] = {
                        uid: String(account.uid),
                        avatarId: account.display_name.default_avatar,
                        login: account.login,
                        name: account.display_name.name,
                        displayName: account.display_name.name || account.display_login,
                        displayLogin: account.display_login || account.login,
                        preferred_auth_method: acc.preferred_auth_method,
                        allowed_auth_methods: acc.allowed_auth_methods
                    };
                });
            }

            if (req.query.mode === 'add-user') {
                needEmpty = true;
            }

            if (res.submitErrors) {
                errors = res.submitErrors[0];
                captchaRequired = ['captcha.required', 'captcha.invalid'].indexOf(errors) > -1;
            }

            if (req.body.login || req.query.login) {
                form.login = req.body.login || req.query.login;
            }

            if (requestedUid) {
                if (suggestedAccounts.length) {
                    suggestedAccounts.forEach(function(acc) {
                        const account = acc.account;

                        if (
                            account &&
                            String(account.uid) === requestedUid &&
                            unitedAccounts[account.uid].status !== 'VALID'
                        ) {
                            processedAccount = unitedAccounts[account.uid];
                        }
                    });
                }

                if (!processedAccount && Object.keys(suggestedAccounts).length === 1) {
                    needEmpty = true;
                }
            }

            defaultAccount = authorizedAccounts.find((o) => o.uid === authorizedAccountsDefaultUid);

            if (!processedAccount && suggestedAccounts.length && !needEmpty) {
                processedAccount = unitedAccounts[suggestedAccounts[0].account.uid];
            }

            if (needEmpty) {
                processedAccount = null;
            }

            if (form.login) {
                processedAccount = null;

                if (Object.keys(unitedAccounts).length) {
                    Object.keys(unitedAccounts).forEach(function(uid) {
                        const account = unitedAccounts[uid];

                        if (account && (account.login === form.login || account.display_login === form.login)) {
                            processedAccount = unitedAccounts[account.uid];
                        }
                    });
                }
            }

            Object.assign(resultStore, {
                authorizedAccounts,
                captchaIsEmpty,
                captchaRequired,
                form,
                formIsSubmitted,
                formIsUpgraded,
                inputLogins,
                isAccountListEditing,
                isExpanded,
                loginIsEmpty,
                authorizedAccountsDefaultUid,
                defaultAccount,
                canAddMore,
                method,
                needEmpty,
                passwordIsEmpty,
                passwordType,
                processedAccount,
                submitCounter,
                suggestedAccounts,
                unitedAccounts
            });

            return next();
        }
    ];
};
