const url = require('url');
const commonConfig = require('../../../../configs/common');
const config = require('../../../../configs/current');

const LangSwitcherView = require('../../../../blocks/layout/LangSwitcherView');
const getUatraitsData = require('../../../common/getUatraitsData');
const langSetup = require('../../../common/langSetup');

const RTL_LOCALES = ['he', 'ar'];

module.exports = function getSettings() {
    return [
        getUatraitsData,
        langSetup,
        (req, res, next) => {
            const langSwitcher = new LangSwitcherView(req._controller);

            langSwitcher._compile().then((result) => {
                res.locals.langlist = (result && result.langlist) || [];

                return next();
            });
        },
        (req, res, next) => {
            const storeDraft = res.locals.store || (res.locals.store = {});
            const resultStore = storeDraft.settings || (storeDraft.settings = {});
            const tld = req._controller.getTld();
            const intranet = process.env.INTRANET === 'intranet';
            const env = {
                type: process.env.NODE_ENV,
                name: process.env.INTRANET
            };
            const {help, avatar, static: defaultStatic, ysa = {}} = config.paths;
            const {static: ysaPath} = ysa;
            const host = url.format({
                protocol: req.headers['x-real-scheme'],
                hostname: req.hostname
            });
            const staticPath = defaultStatic;
            const {language, langlist, ua = {}, regionId, countryId, userType = {}} = res.locals;
            const {version} = config;
            const {metricsUserType} = userType;
            const legalLinks = {
                rules: commonConfig.legalLinks.rules.replace('%tld%', tld),
                confidential: commonConfig.legalLinks.confidential.replace('%tld%', tld)
            };

            Object.assign(resultStore, {
                avatar,
                staticPath,
                env,
                help,
                intranet,
                language,
                // lang в settings появился только в авторизации и используется
                // в определении какие чанки подгружать и в некоторых запросах
                // приоритетно будем пользоваться language, как во всем паспорте
                // lang остается для фолбэка, чтобы случайно не сломать что-то
                lang: language,
                langlist,
                dir: RTL_LOCALES.includes(language) ? 'rtl' : 'ltr',
                metricsUserType,
                tld,
                legalLinks,
                host,
                ua,
                isNoTabletTouch: (ua.isMobile || ua.isTouch) && !ua.isTablet,
                regionId,
                countryId,
                version,
                ysaPath
            });

            return next();
        }
    ];
};
