const config = require('../../../../configs/current');
const {getSocialProviders} = require('../../../common/socialSetup');
const getCustomConfigByRequest = require('../../../common/getCustomConfigByRequest');

const filterProviders = (providers) => (provider) => providers.includes((provider.data || {}).code);

module.exports = function getSocial() {
    return [
        getSocialProviders,
        (req, res, next) => {
            const storeDraft = res.locals.store || (res.locals.store = {});
            const resultStore = storeDraft.social || (storeDraft.social = {});
            const originConfig = getCustomConfigByRequest(req) || {};
            const brokerPath = config.paths.broker;
            const brokerParams = config.brokerParams;

            let providers = JSON.parse(JSON.stringify((res.locals.socialProviders || {}).providers || []));

            if (!req._controller.hasExp('social-auth-esia-exp')) {
                providers = providers.filter((provider) => (provider.data || {}).code !== 'esia');
            }

            if (originConfig.providers) {
                providers = providers.filter(filterProviders(originConfig.providers));
            }

            Object.assign(resultStore, {
                providers,
                brokerPath,
                brokerParams
            });

            return next();
        }
    ];
};
