const express = require('express');
const router = express.Router();
const langSetup = require('../../common/langSetup');
const apiSetup = require('../../common/apiSetup');
const getUatraitsData = require('../../common/getUatraitsData');
const writeStatbox = require('../../common/writeStatbox');
const rumCounterSetup = require('../../common/rumCounterSetup');
const AUTH_MODES = ['auth', 'edit', 'add-user', 'qr'];

const chooseMode = require('../common/chooseMode.js');
const getYaExperimentsFlags = require('../../common/getYaExperimentsFlags');

const getCommon = require('../common/getStore/getCommon.js');
const getSettings = require('../common/getStore/getSettings.js');
const getSocial = require('../common/getStore/getSocial.js');
const getMetrics = require('../../common/getMetrics.js');
const getMonitoring = require('../common/getStore/getMonitoring.js');
const getCaptcha = require('../../common/getCaptcha.js');
const getOneDomik = require('../common/getStore/getOneDomik.js');
const getCustomsByOrigin = require('../common/getStore/getCustomsByOrigin.js');

function prepareStatData(req, res, next) {
    const locals = res.locals;
    const oneDomik = locals.store.one_domik;
    const common = locals.store.common;

    res.locals.preparedStat = Object.assign(
        {},
        {
            opened_state: locals.mode,
            track_id: common.track_id || null,
            default_uid: oneDomik.authorizedAccountsDefaultUid || null,
            auth_accounts: String(oneDomik.authorizedAccounts.length),
            sugg_accounts: String(oneDomik.suggestedAccounts.length)
        }
    );

    return next();
}

function renderPage(req, res) {
    const locals = res.locals;
    const lang = locals.language;

    let pane = req.originalUrl;

    // console.log(JSON.stringify(res.locals.store, null, 4));
    if (res.locals.mode) {
        const mode = res.locals.mode;

        if (mode === 'edit') {
            pane = '/auth/list';
        } else if (mode === 'welcome') {
            pane = '/auth/welcome';
        } else if (mode === 'magic') {
            pane = '/auth/magic';
        } else if (mode === 'addingAccount') {
            pane = '/auth';
        }
    }

    res.locals.store.common.pane = pane;
    res.locals.track_id = res.locals.store.common.track_id;
    res.render(`auth.stepped.${lang}.jsx`);
}

const getRoute = [
    apiSetup,
    getUatraitsData,
    getYaExperimentsFlags,
    (req, res, next) => {
        const mode = req.query.mode;
        const isNewAuthEnabled = !mode || AUTH_MODES.indexOf(mode) !== -1;

        if (!isNewAuthEnabled) {
            return next();
        }

        return next('route');
    },
    langSetup,
    getCommon(),
    getSettings(),
    getSocial(),
    getMetrics({
        header: 'Новый домик V2'
    }),
    getMonitoring({
        page: 'auth.stepped'
    }),
    getCaptcha(),
    getOneDomik(),
    getCustomsByOrigin,
    rumCounterSetup,
    chooseMode,
    prepareStatData,
    writeStatbox({
        action: 'opened',
        mode: 'one_domik'
    }),
    renderPage
];

router.get('/', getRoute);
router.get('/magic', getRoute);
router.get('/add', getRoute);
router.get('/list', getRoute);
router.get('/welcome', getRoute);

exports.router = router;
