const PLog = require('plog');

async function otpEnableCheckOtp(req, res) {
    try {
        const result = await req.api.OTPEnableCheckOtp(req.body.otp);

        res.json(result);
    } catch (error) {
        PLog.warn()
            .logId(req.logID)
            .type('otpEnableCheckOtp')
            .write(error);

        res.json({status: 'error', errors: Array.isArray(error) ? error : ['internal']});
    }
}

module.exports = {
    otpEnableCheckOtp
};
