const PLog = require('plog');

async function otpEnableCommit(req, res) {
    try {
        const result = await req.api.OTPEnableCommit();

        res.json(result);
    } catch (error) {
        PLog.warn()
            .logId(req.logID)
            .type('otpEnableCommit')
            .write(error);

        res.json({status: 'error', errors: Array.isArray(error) ? error : ['internal']});
    }
}

module.exports = {
    otpEnableCommit
};
