const PLog = require('plog');

async function otpEnableGetSecret(req, res) {
    try {
        const secretResult = await req.api.OTPEnableGetSecret();

        res.json(secretResult);
    } catch (error) {
        PLog.warn()
            .logId(req.logID)
            .type('otpEnableGetSecret')
            .write(error);

        res.json({status: 'error', errors: Array.isArray(error) ? error : ['internal']});
    }
}

module.exports = {
    otpEnableGetSecret
};
