const PLog = require('plog');
const config = require('../../configs/current');

async function otpEnableSubmit(req, res) {
    try {
        const otpResponse = await req.api.OTPEnableSubmit(req.body.track_id, config.otpSessionReissueInterval);

        await req.api.track(otpResponse.track_id);

        res.json(otpResponse);
    } catch (error) {
        PLog.warn()
            .logId(req.logID)
            .type('otpEnableSubmit')
            .write(error);

        res.json({status: 'error', errors: Array.isArray(error) ? error : ['internal']});
    }
}

module.exports = {
    otpEnableSubmit
};
