const {correctForm} = require('./correctForm');
const {handleNonFormErrors} = require('./handleNonFormErrors');

function doCompleteSubmit(req, res, next) {
    const {store = {}} = res.locals;
    const {settings = {}, common = {}, form = {}} = store;
    const {track_id, retpath} = common;
    const isMobile = settings.isMobile;

    if (res.locals.skipSubmit) {
        correctForm({form, isMobile});
        return next();
    }

    const data = {retpath};

    if (track_id) {
        data.track_id = track_id;
    }

    return req.api.completeSubmit(data).then(
        (result) => {
            if (result.body && result.body.status === 'ok') {
                const body = result.body;
                const phone = body.phone_number || body.phone_number_confirmed;
                const validationMethod = body['human-confirmation'];
                const isLiteWithoutPassword = body.state === 'complete_lite' && res.locals.isUserWithoutPassword;

                let hasRecoveryMethod = body.has_recovery_method;

                if (hasRecoveryMethod === undefined && validationMethod === undefined) {
                    hasRecoveryMethod = true;
                }

                res.locals.result.completeSubmit = body;
                res.locals.store.person.hasRecoveryMethod = hasRecoveryMethod;
                res.locals.store.common.track_id = body.track_id;
                form.type = body.state;

                if (isLiteWithoutPassword) {
                    res.locals.store.person.isLiteWithoutPassword = true;
                }

                correctForm({form, hasRecoveryMethod, isMobile});

                if (phone && validationMethod === 'phone') {
                    form.values.phone = phone;
                    form.states.phone = 'valid';
                    form.validation.humanConfirmationDone = true;
                }

                return next();
            }

            return next(new Error());
        },
        (error) => {
            return handleNonFormErrors(error, req, res, next);
        }
    );
}

module.exports = {
    doCompleteSubmit
};
