function doKeyLinkSubmit(req, res, next) {
    const secretKey = req.query && req.query.key;

    if (secretKey) {
        return req.api
            .authKeyLinkSubmit({
                secret_key: secretKey
            })
            .then((results) => {
                const {state, track_id: trackId} = results.body;

                res.locals.store.common.track_id = trackId;
                res.locals.store.form.type = state;

                const localResult = res.locals.result || (res.locals.result = {});

                localResult.authKeyLinkSubmit = {
                    track_id: trackId,
                    state,
                    account: {},
                    has_recovery_method: false
                };

                if (state === 'complete_autoregistered') {
                    res.locals.skipSubmit = true;
                }

                return next();
            }, next);
    }
}

module.exports = {
    doKeyLinkSubmit
};
