const url = require('url');
const PLog = require('plog');
const _ = require('lodash');

const {AUTH_REG_COMPLETE_LOG_TYPE} = require('./constants');

const ERRORS_FOR_SET_RETPATH = [
    'action.not_required',
    'account.disabled',
    'account.global_logout',
    'sessionid.invalid',
    'sslsession.required'
];

function handleNonFormErrors(err, req, res, next) {
    PLog.warn()
        .logId(req.logID)
        .type(AUTH_REG_COMPLETE_LOG_TYPE)
        .write(err);

    if (req.method === 'POST') {
        return res.json({status: 'error', error: err});
    }

    if (err instanceof Error) {
        return next(err);
    }

    const currentUrl = url.parse(req.originalUrl, true);
    const defaultRetpathObj = {
        protocol: req.headers['x-real-scheme'],
        hostname: req.hostname,
        pathname: 'passport',
        query: {
            mode: 'passport'
        }
    };

    let retpathToComplete;

    if (Array.isArray(err) && err.some((error) => ERRORS_FOR_SET_RETPATH.includes(error))) {
        retpathToComplete = _.clone(defaultRetpathObj, true);

        if (err.some((error) => ['sessionid.invalid', 'sslsession.required'].includes(error))) {
            retpathToComplete.pathname = 'auth';
            retpathToComplete.query.retpath = url.format(
                Object.assign({}, defaultRetpathObj, {
                    pathname: currentUrl.pathname,
                    query: currentUrl.query,
                    search: null
                })
            );
            delete retpathToComplete.query.mode;
        }

        if (err.includes('sslsession.required')) {
            retpathToComplete.pathname = 'auth/secure';
        }

        return res.redirect(url.format(retpathToComplete));
    }

    return next(err);
}

module.exports = {
    handleNonFormErrors
};
