const apiSetup = require('../common/apiSetup');
const {captchaGenerate} = require('../common/captchaGenerate');
const checkAuth = require('../common/checkAuth');
const createCustomsState = require('../common/createCustomsState');
const createFormState = require('../common/createFormState');
const getCaptcha = require('../common/getCaptcha');
const getCountry = require('../common/getCountry');
const getMetrics = require('../common/getMetrics');
const getYaExperimentsFlags = require('../common/getYaExperimentsFlags');
const {getQuestions} = require('../common/loadQuestions');
const rumCounterSetup = require('../common/rumCounterSetup');
const writeStatbox = require('../common/writeStatbox');

const setRegistrationPhoneOnly = require('../registration/setRegistrationPhoneOnly');

const createCommonState = require('../authv2/createCommonState');
const createPagePopupState = require('../authv2/createPagePopupState');

const getSettings = require('../auth/common/getStore/getSettings');

const {doCompleteSubmit} = require('./doCompleteSubmit');
const {doKeyLinkSubmit} = require('./doKeyLinkSubmit');
const {AUTH_REG_COMPLETE_LOG_TYPE} = require('./constants');
const {createStore} = require('./createStore');
const {profileGetState} = require('./profileGetState');
const {redirectToRetpathIfNothingToDo} = require('./redirectToRetpathIfNothingToDo');
const {renderPage} = require('./renderPage');

const express = require('express');
const router = express.Router();

const commonMiddlePart = [
    apiSetup,
    getYaExperimentsFlags,
    getCountry,
    createCommonState(),
    getCaptcha(),
    createPagePopupState,
    getQuestions(AUTH_REG_COMPLETE_LOG_TYPE),
    captchaGenerate(AUTH_REG_COMPLETE_LOG_TYPE),
    createFormState,
    profileGetState,
    getSettings(),
    createCustomsState,
    createStore,
    writeStatbox({
        action: 'opened',
        mode: 'auth_reg_complete'
    }),
    getMetrics({
        header: 'Дорегистрация'
    }),
    rumCounterSetup
];

const commonEndPart = [doCompleteSubmit, renderPage, redirectToRetpathIfNothingToDo];

const rootRoute = [checkAuth, commonMiddlePart, setRegistrationPhoneOnly, commonEndPart];

const enterLite = [checkAuth, commonMiddlePart, commonEndPart];

const enterAuth = [commonMiddlePart, doKeyLinkSubmit, commonEndPart];

router.get('/autoregistered', rootRoute);
router.get('/lite', enterLite);
router.get('/key_link', enterAuth);

exports.router = router;
