const PLog = require('plog');
const _ = require('lodash');
const {AUTH_REG_COMPLETE_LOG_TYPE} = require('./constants');

function profileGetState(req, res, next) {
    return req.api
        .profileGetState()
        .then((response) => {
            const form = res.locals.store.form;
            const profile = response.body;
            const account = profile.account || {};
            const person = account.person || {};

            person.provider = _.get(account, 'display_name.social.provider');
            res.locals.account = account;
            res.locals.isSocialchik = _.get(account, 'password_info.strength', null) === -1 && !account.is_2fa_enabled;
            res.locals.isUserWithoutPassword = res.locals.isSocialchik;

            if (person.firstname) {
                form.values.firstname = person.firstname;
                form.states.firstname = 'valid';
            }
            if (person.lastname) {
                form.values.lastname = person.lastname;
                form.states.lastname = 'valid';
            }
            form.isEulaShowedInPopup = true;

            return next();
        })
        .catch((errors) => {
            res.locals.account = {};
            res.locals.isSocialchik = false;

            PLog.warn()
                .logId(req.logID)
                .type(AUTH_REG_COMPLETE_LOG_TYPE)
                .write(errors);

            return next();
        });
}

module.exports = {
    profileGetState
};
