const _ = require('lodash');
const url = require('url');

function redirectToRetpathIfNothingToDo(req, res, next) {
    if (!res.locals.result.completeSubmit.state) {
        const validatedRetpath = _.get(res, 'locals.store.common.retpath');

        if (validatedRetpath) {
            return res.redirect(validatedRetpath);
        }

        const defaultRetpath = url.format({
            protocol: req.headers['x-real-scheme'],
            hostname: req.hostname,
            pathname: 'passport',
            query: {
                mode: 'passport'
            }
        });

        return res.redirect(defaultRetpath);
    } else {
        next();
    }
}

module.exports = {
    redirectToRetpathIfNothingToDo
};
