const url = require('url');

function renderPage(req, res, next) {
    const metricsHeaders = {
        complete_social: 'Дорегистрация социальщиков с логином',
        complete_social_with_login: 'Дорегистрация социальщиков',
        complete_lite: 'Дорегистрация лайтов',
        complete_autoregistered: 'Дорегистрация авторегистрированных',
        complete_neophonish: 'Дорегистрация неофониша'
    };
    const retpath = res.locals.store.common.retpath;
    const lang = res.locals.language;
    const body = res.locals.result.completeSubmit || res.locals.result.authKeyLinkSubmit || {};
    const account = body.account;
    const pathToLightAuthToFull = {
        protocol: req.headers['x-real-scheme'],
        hostname: req.hostname,
        pathname: 'passport',
        query: {
            mode: 'lightauth2full'
        }
    };

    if (!body.state) {
        return next();
    }

    if (body.state === 'upgrade_cookies') {
        if (retpath) {
            pathToLightAuthToFull.query.retpath = retpath;
        }

        return res.redirect(url.format(pathToLightAuthToFull));
    }

    if (metricsHeaders.hasOwnProperty(body.state)) {
        res.locals.store.metrics.header = metricsHeaders[body.state];
    }

    const experimentFlags = res.locals.experiments && res.locals.experiments.flagsString;
    const experimentBoxes = res.locals.experiments && res.locals.experiments.boxes;

    req.api.statboxLogger({
        ignoreMissedTrack: true,
        track_id: body.track_id || res.locals.store.common.track_id,
        uid: account && account.uid,
        action: 'opened',
        mode: 'complete.v3',
        ip: req.headers['x-real-ip'],
        user_agent: req.headers['user-agent'],
        yandexuid: res._yandexuid && res._yandexuid.replace(/[^0-9]/g, ''),
        state: body.state,
        has_recovery_method: String(body.has_recovery_method),
        experiment_flags: experimentFlags,
        experiment_boxes: experimentBoxes
    });

    return res.render(`react.auth-reg-complete.${lang}.jsx`);
}

module.exports = {
    renderPage
};
