const url = require('url');
const config = require('../../configs/current');

module.exports = function createStore(req, res, next) {
    const locals = res.locals;
    const {userType = {}} = locals;
    const {version, paths = {}} = config;
    const {static: staticPath} = paths;
    const {metricsUserType} = userType;
    const tld = req._controller.getTld();

    locals.store = {
        settings: {
            version,
            metricsUserType,
            staticPath,
            language: locals.language,
            tld
        }
    };

    locals.store.main = {};

    let retpath;

    if (locals.result && locals.result.validateRetpath && locals.result.validateRetpath.retpath) {
        retpath = locals.result.validateRetpath.retpath;
    } else {
        retpath = url.format(
            Object.assign(req._controller.getUrl(), {
                pathname: '/profile',
                query: req.query
            })
        );
    }

    // TODO временно так для тестирования фичи
    // const passportURL = config.paths.passport.replace('%tld%', tld);
    const passportURL = 'passport.yandex.ru';

    locals.store.main.url = `https://${passportURL}/am/pssp/browser/account?url=${encodeURIComponent(retpath)}`;

    if (res.locals.ua && res.locals.ua.BrowserName) {
        locals.store.main.url += `&BrowserName=${res.locals.ua.BrowserName}`;
    }

    next();
};
